/* Generated by re2c */

#include <stddef.h> /* size_t */
#include <stdio.h>
#include <stdlib.h> /* malloc, free */
#include <string.h> /* memcpy */

static void *read_file
    ( const char *fname
    , size_t unit
    , size_t padding
    , size_t *pfsize
    )
{
    void *buffer = NULL;
    size_t fsize = 0;

    /* open file */
    FILE *f = fopen(fname, "rb");
    if (f == NULL) {
        goto error;
    }

    /* get file size */
    fseek(f, 0, SEEK_END);
    fsize = (size_t) ftell(f) / unit;
    fseek(f, 0, SEEK_SET);

    /* allocate memory for file and padding */
    buffer = malloc(unit * (fsize + padding));
    if (buffer == NULL) {
        goto error;
    }

    /* read the whole file in memory */
    if (fread(buffer, unit, fsize, f) != fsize) {
        goto error;
    }

    fclose(f);
    *pfsize = fsize;
    return buffer;

error:
    fprintf(stderr, "error: cannot read file '%s'\n", fname);
    free(buffer);
    if (f != NULL) {
        fclose(f);
    }
    return NULL;
}

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line130
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line130: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line130: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line130(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line130: not enough keys\n");
    return 1;
}

int lex_line130()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line130.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line130.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128,   0, 128, 128, 128, 128,   0, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy2;
        }
        if (yych <= '#') goto yy5;
        if (yych <= ':') goto yy7;
        goto yy9;
yy2:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy2;
        }
        status = check_key_count_line130(keys_count, i, 3)
             || action_line130(&i, keys, input, token, &cursor, 3);
        continue;
yy5:
        YYSKIP();
        status = check_key_count_line130(keys_count, i, 3)
             || action_line130(&i, keys, input, token, &cursor, 2);
        continue;
yy7:
        YYSKIP();
        status = check_key_count_line130(keys_count, i, 3)
             || action_line130(&i, keys, input, token, &cursor, 0);
        continue;
yy9:
        YYSKIP();
        status = check_key_count_line130(keys_count, i, 3)
             || action_line130(&i, keys, input, token, &cursor, 1);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line130: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line130: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line316
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line316: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line316: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line316(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line316: not enough keys\n");
    return 1;
}

int lex_line316()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line316.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line316.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128,   0, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy13;
        }
        goto yy16;
yy13:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy13;
        }
        status = check_key_count_line316(keys_count, i, 3)
             || action_line316(&i, keys, input, token, &cursor, 1);
        continue;
yy16:
        YYSKIP();
        status = check_key_count_line316(keys_count, i, 3)
             || action_line316(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line316: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line316: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line323
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line323: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line323: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line323(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line323: not enough keys\n");
    return 1;
}

int lex_line323()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line323.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line323.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy22;
        }
        YYSKIP();
        status = check_key_count_line323(keys_count, i, 3)
             || action_line323(&i, keys, input, token, &cursor, 1);
        continue;
yy22:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy22;
        }
        status = check_key_count_line323(keys_count, i, 3)
             || action_line323(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line323: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line323: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line335
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line335: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line335: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line335(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line335: not enough keys\n");
    return 1;
}

int lex_line335()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line335.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line335.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        {
            static void *yytarget[256] = {
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy29, &&yy29, &&yy29, &&yy27, &&yy29, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy29, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy32,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy33, &&yy27,
                &&yy27, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35, &&yy35,
                &&yy35, &&yy35, &&yy35, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27,
                &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27, &&yy27
            };
            goto *yytarget[yych];
        }
yy27:
        YYSKIP();
yy28:
        status = check_key_count_line335(keys_count, i, 3)
             || action_line335(&i, keys, input, token, &cursor, 3);
        continue;
yy29:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy29;
        }
        status = check_key_count_line335(keys_count, i, 3)
             || action_line335(&i, keys, input, token, &cursor, 1);
        continue;
yy32:
        YYSKIP();
        yych = YYPEEK();
        if (yych != '>') goto yy28;
yy33:
        YYSKIP();
        status = check_key_count_line335(keys_count, i, 3)
             || action_line335(&i, keys, input, token, &cursor, 0);
        continue;
yy35:
        YYSKIP();
        status = check_key_count_line335(keys_count, i, 3)
             || action_line335(&i, keys, input, token, &cursor, 2);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line335: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line335: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line342
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line342: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line342: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line342(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line342: not enough keys\n");
    return 1;
}

int lex_line342()
{
    const size_t padding = 1; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line342.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line342.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0, 128,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128, 128, 128, 128, 128, 128, 
            128, 128, 128,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych <= '@') goto yy39;
        if (yych <= 'Z') goto yy41;
        if (yych <= '`') goto yy39;
        if (yych <= 'z') goto yy41;
yy39:
        YYSKIP();
        status = check_key_count_line342(keys_count, i, 3)
             || action_line342(&i, keys, input, token, &cursor, 1);
        continue;
yy41:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy41;
        }
        status = check_key_count_line342(keys_count, i, 3)
             || action_line342(&i, keys, input, token, &cursor, 0);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line342: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line342: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line349
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line349: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line349: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line349(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line349: not enough keys\n");
    return 1;
}

int lex_line349()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line349.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line349.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
            128,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
              0,   0,   0,   0,   0,   0,   0,   0, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        if (yych == ' ') goto yy48;
        if (yych == '=') goto yy49;
        YYSKIP();
yy47:
        status = check_key_count_line349(keys_count, i, 3)
             || action_line349(&i, keys, input, token, &cursor, 1);
        continue;
yy48:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == ' ') goto yy52;
        if (yych != '=') goto yy47;
yy49:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 128) {
            goto yy49;
        }
        status = check_key_count_line349(keys_count, i, 3)
             || action_line349(&i, keys, input, token, &cursor, 0);
        continue;
yy52:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yych == ' ') goto yy52;
        if (yych == '=') goto yy49;
        YYRESTORE();
        goto yy47;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line349: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line349: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

#define YYCTYPE unsigned char
#define YYKEYTYPE unsigned char
#define YYPEEK() *cursor
#define YYSKIP() ++cursor
#define YYBACKUP() marker = cursor
#define YYRESTORE() cursor = marker
#define YYSHIFT(o) cursor += o
#define YYLESSTHAN(n) (limit - cursor) < n
#define YYFILL(n) { break; }

static int action_line359
    ( unsigned *pkix
    , const YYKEYTYPE *keys
    , const YYCTYPE *start
    , const YYCTYPE *token
    , const YYCTYPE **cursor
    , YYKEYTYPE rule_act
    )
{
    const unsigned kix = *pkix;
    const long pos = token - start;
    const long len_act = *cursor - token;
    const long len_exp = (long) keys[kix + 1];
    const YYKEYTYPE rule_exp = keys[kix + 2];
    *pkix = kix + 3;
    if (rule_exp == 255) {
        fprintf
            ( stderr
            , "warning: lex_line359: control flow is undefined"
                " for input at position %ld, rerun re2c with '-W'\n"
            , pos
            );
    }
    if (len_act == len_exp && rule_act == rule_exp) {
        const YYKEYTYPE offset = keys[kix];
        *cursor = token + offset;
        return 0;
    } else {
        fprintf
            ( stderr
            , "error: lex_line359: at position %ld (key %u):\n"
                "\texpected: match length %ld, rule %u\n"
                "\tactual:   match length %ld, rule %u\n"
            , pos
            , kix
            , len_exp
            , rule_exp
            , len_act
            , rule_act
            );
        return 1;
    }
}

static int check_key_count_line359(unsigned have, unsigned used, unsigned need)
{
    if (used + need <= have) return 0;
    fprintf(stderr, "error: lex_line359: not enough keys\n");
    return 1;
}

int lex_line359()
{
    const size_t padding = 2; /* YYMAXFILL */
    int status = 0;
    size_t input_len = 0;
    size_t keys_count = 0;
    YYCTYPE *input = NULL;
    YYKEYTYPE *keys = NULL;
    const YYCTYPE *cursor = NULL;
    const YYCTYPE *limit = NULL;
    const YYCTYPE *token = NULL;
    const YYCTYPE *eof = NULL;
    unsigned int i = 0;

    input = (YYCTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line359.input"
        , sizeof (YYCTYPE)
        , padding
        , &input_len
        );
    if (input == NULL) {
        status = 1;
        goto end;
    }

    keys = (YYKEYTYPE *) read_file
        ( "skeleton/php20150211_url_scanner_ex.c.line359.keys"
        , sizeof (YYKEYTYPE)
        , 0
        , &keys_count
        );
    if (keys == NULL) {
        status = 1;
        goto end;
    }

    cursor = input;
    limit = input + input_len + padding;
    eof = input + input_len;

    for (i = 0; status == 0 && cursor < eof && i < keys_count;) {
        token = cursor;
        const YYCTYPE *marker = NULL;
        YYCTYPE yych;
        static const unsigned char yybm[] = {
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 192, 192, 224, 224, 192, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            192, 224, 128, 224, 224, 224, 224,  64, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224,   0, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
            224, 224, 224, 224, 224, 224, 224, 224, 
        };

        if (YYLESSTHAN(2)) YYFILL(2);
        yych = YYPEEK();
        if (yybm[0+yych] & 32) {
            goto yy57;
        }
        if (yych <= ' ') goto yy60;
        if (yych <= '"') goto yy62;
        if (yych <= '\'') goto yy63;
        goto yy60;
yy57:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
        if (yybm[0+yych] & 32) {
            goto yy57;
        }
        status = check_key_count_line359(keys_count, i, 3)
             || action_line359(&i, keys, input, token, &cursor, 2);
        continue;
yy60:
        YYSKIP();
yy61:
        status = check_key_count_line359(keys_count, i, 3)
             || action_line359(&i, keys, input, token, &cursor, 3);
        continue;
yy62:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == '>') goto yy61;
        goto yy65;
yy63:
        YYSKIP();
        YYBACKUP();
        yych = YYPEEK();
        if (yych == '>') goto yy61;
        goto yy70;
yy64:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
yy65:
        if (yybm[0+yych] & 64) {
            goto yy64;
        }
        if (yych <= '"') goto yy67;
yy66:
        YYRESTORE();
        goto yy61;
yy67:
        YYSKIP();
        status = check_key_count_line359(keys_count, i, 3)
             || action_line359(&i, keys, input, token, &cursor, 0);
        continue;
yy69:
        YYSKIP();
        if (YYLESSTHAN(1)) YYFILL(1);
        yych = YYPEEK();
yy70:
        if (yybm[0+yych] & 128) {
            goto yy69;
        }
        if (yych >= '(') goto yy66;
        YYSKIP();
        status = check_key_count_line359(keys_count, i, 3)
             || action_line359(&i, keys, input, token, &cursor, 1);
        continue;

    }
    if (status == 0) {
        if (cursor != eof) {
            status = 1;
            const long pos = token - input;
            fprintf(stderr, "error: lex_line359: unused input strings left at position %ld\n", pos);
        }
        if (i != keys_count) {
            status = 1;
            fprintf(stderr, "error: lex_line359: unused keys left after %u keys\n", i);
        }
    }

end:
    free(input);
    free(keys);

    return status;
}

#undef YYCTYPE
#undef YYKEYTYPE
#undef YYPEEK
#undef YYSKIP
#undef YYBACKUP
#undef YYRESTORE
#undef YYLESSTHAN
#undef YYFILL

int main()
{
    if (lex_line130() != 0) {
        return 1;
    }
    if (lex_line316() != 0) {
        return 1;
    }
    if (lex_line323() != 0) {
        return 1;
    }
    if (lex_line335() != 0) {
        return 1;
    }
    if (lex_line342() != 0) {
        return 1;
    }
    if (lex_line349() != 0) {
        return 1;
    }
    if (lex_line359() != 0) {
        return 1;
    }
    return 0;
}
  #:?#:?#:?		#

:?#

:?#:?#:?#:?#:?#:?#:  ?!!#"":$$?%%#&&:''?((#)):**?++#,,:--?..#//:00?11#22:33?44#55:66?77#88:99?;;#<<:==?>>#@@:AA?BB#CC:DD?EE#FF:GG?HH#II:JJ?KK#LL:MM?NN#OO:PP?QQ#RR:SS?TT#UU:VV?WW#XX:YY?ZZ#[[:\\?]]#^^:__?``#aa:bb?cc#dd:ee?ff#gg:hh?ii#jj:kk?ll#mm:nn?oo#pp:qq?rr#ss:tt?uu#vv:ww?xx#yy:zz?{{#||:}}?~~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?# #:?#:?#:?	#
:?#
:?#:?#:?#:?#:?#:?#: ?!#":$?%#&:'?(#):*?+#,:-?.#/:0?1#2:3?4#5:6?7#8:9?;#<:=?>#@:A?B#C:D?E#F:G?H#I:J?K#L:M?N#O:P?Q#R:S?T#U:V?W#X:Y?Z#[:\?]#^:_?`#a:b?c#d:e?f#g:h?i#j:k?l#m:n?o#p:q?r#s:t?u#v:w?x#y:z?{#|:}?~#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?#:?##:?   <<<<<<<<<		<

<<<

<<<<<<<<<<<<<<<<<<<  <!!<""<##<$$<%%<&&<''<((<))<**<++<,,<--<..<//<00<11<22<33<44<55<66<77<88<99<::<;;<==<>><??<@@<AA<BB<CC<DD<EE<FF<GG<HH<II<JJ<KK<LL<MM<NN<OO<PP<QQ<RR<SS<TT<UU<VV<WW<XX<YY<ZZ<[[<\\<]]<^^<__<``<aa<bb<cc<dd<ee<ff<gg<hh<ii<jj<kk<ll<mm<nn<oo<pp<qq<rr<ss<tt<uu<vv<ww<xx<yy<zz<{{<||<}}<~~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<< <<<<<<<<<	<
<<<
<<<<<<<<<<<<<<<<<<< <!<"<#<$<%<&<'<(<)<*<+<,<-<.</<0<1<2<3<4<5<6<7<8<9<:<;<=<><?<@<A<B<C<D<E<F<G<H<I<J<K<L<M<N<O<P<Q<R<S<T<U<V<W<X<Y<Z<[<\<]<^<_<`<a<b<c<d<e<f<g<h<i<j<k<l<m<n<o<p<q<r<s<t<u<v<w<x<y<z<{<|<}<~<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<  	

 !"#$%&'()*+,-./0123456789;<=>?@[\]^_`{|}~:: AABBCCDDEEFFGGHHII	JJ
KKLLMM
NNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeff gg!hh"ii#jj$kk%ll&mm'nn(oo)pp*qq+rr,ss-tt.uu/vv0ww1xx2yy3zz4::5AA6BB7CC8DD9EE;FF<GG=HH>II?JJ@KK[LL\MM]NN^OO_PP`QQ{RR|SS}TT~UUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqqrrssttuuvvwwxxyyzz::AABBCCDDEEFFGGHHIIJJKKLLMMNNOOPPQQRRSSTTUUVVWWXXYYZZaabbccddeeffgghhiijjkkllmmnnooppqq: ABCDEFGHI	J
KLM
NOPQRSTUVWXYZabcdef g!h"i#j$k%l&m'n(o)p*q+r,s-t.u/v0w1x2y3z4:5A6B7C8D9E;F<G=H>I?J@K[L\M]N^O_P`Q{R|S}T~UVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz:ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopq                                                                                                                                                                                                                                                                                                                                                                                                                       !"#$%&'()*+,-.0123456789:;<=?@[\]^_`{|}~		 



  		



  		



  		



  		



  		



!  "		#

$%

&  '		(

)*

+  ,		-

./

0  1		2

34

5  6		7

89

:  ;		<

=>

?  @		A

BC

D  E		F

GH

I  J		K

LM

N  O		P

QR

S  T		U

VW

X  Y		Z

[\

]  ^		_

`a

b  c		d

ef

g  h		i

jk

l  m		n

op

q  r		s

tu

v  w		x

yz

{  |		}

~

  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  		



  			 

 	

 	

 	

 	

 	

! "	#
$%
& '	(
)*
+ ,	-
./
0 1	2
34
5 6	7
89
: ;	<
=>
? @	A
BC
D E	F
GH
I J	K
LM
N O	P
QR
S T	U
VW
X Y	Z
[\
] ^	_
`a
b c	d
ef
g h	i
jk
l m	n
op
q r	s
tu
v w	x
yz
{ |	}
~
 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	

 	/>/ /////////	/
///
/////////////////// /!/"/#/$/%/&/'/(/)/*/+/,/-/.///0/1/2/3/4/5/6/7/8/9/:/;/</=/?/@/A/B/C/D/E/F/G/H/I/J/K/L/M/N/O/P/Q/R/S/T/U/V/W/X/Y/Z/[/\/]/^/_/`/a/b/c/d/e/f/g/h/i/j/k/l/m/n/o/p/q/r/s/t/u/v/w/x/y/z/{/|/}/~/////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////>ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz   	

 !"#$%&'()*+,-./0123456789:;<=>?@[\]^_`{|}~A- BACBDCEDFEGFHGIHJI	KJ
LKMLNM
ONPOQPRQSRTSUTVUWVXWYXZYaZbacbdcedfegf hg!ih"ji#kj$lk%ml&nm'on(po)qp*rq+sr,ts.ut/vu0wv1xw2yx3zy4Az5B-6CA7DB8EC9FD:GE;HF<IG=JH>KI?LJ@MK[NL\OM]PN^QO_RP`SQ{TR|US}VT~WUXVYWZXaYbZcadbecfdgehfigjhkiljmknlompnqorpsqtrusvtwuxvywzxAyBzC-DAEBFCGDHEIFJGKHLIMJNKOLPMQNROSPTQURVSWTXUYVZWaXbYcZdaebfcgdheifjgkhlimjnkolpmqnrosptqurvswtxuyvzwAxByCzD-EAFBGCHDIEJFKGLHMINJOKPLQMRNSOTPUQVRWSXTYUZVaWbXcYdZeafbgchdiejfkglhminjokplqmrnsotpuqA BCDEFGHIJ	K
LMN
OPQRSTUVWXYZabcdefg h!i"j#k$l%m&n'o(p)q*r+s,t.u/v0w1x2y3z4A5B6C7D8E9F:G;H<I=J>K?L@M[N\O]P^Q_R`S{T|U}V~WXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstu                                                                                                                                                                                                                                                                                                                                                                                                                       	

!"#$%&'()*+,-./0123456789:;<>?@ABCDEFGHIJKLMNOPQRSTUVWXYZ[\]^_`abcdefghijklmnopqrstuvwxyz{|}~ =   =  =  =  =  =  =  =  =  = 	 = 
 =  =  = 
 =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = ! = " = # = $ = % = & = ' = ( = ) = * = + = , = - = . = / = 0 = 1 = 2 = 3 = 4 = 5 = 6 = 7 = 8 = 9 = : = ; = < = = = > = ? = @ = A = B = C = D = E = F = G = H = I = J = K = L = M = N = O = P = Q = R = S = T = U = V = W = X = Y = Z = [ = \ = ] = ^ = _ = ` = a = b = c = d = e = f = g = h = i = j = k = l = m = n = o = p = q = r = s = t = u = v = w = x = y = z = { = | = } = ~ =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  = = = = = = = = =	 =
 = = =
 = = = = = = = = = = = = = = = = = = =! =" =# =$ =% =& =' =( =) =* =+ =, =- =. =/ =0 =1 =2 =3 =4 =5 =6 =7 =8 =9 =: =; =< == => =? =@ =A =B =C =D =E =F =G =H =I =J =K =L =M =N =O =P =Q =R =S =T =U =V =W =X =Y =Z =[ =\ =] =^ =_ =` =a =b =c =d =e =f =g =h =i =j =k =l =m =n =o =p =q =r =s =t =u =v =w =x =y =z ={ =| =} =~ = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = =  =   =  =  =  =  =  =  =  =  =	  =
  =  =  =
  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =!  ="  =#  =$  =%  =&  ='  =(  =)  =*  =+  =,  =-  =.  =/  =0  =1  =2  =3  =4  =5  =6  =7  =8  =9  =:  =;  =<  ==  =>  =?  =@  =A  =B  =C  =D  =E  =F  =G  =H  =I  =J  =K  =L  =M  =N  =O  =P  =Q  =R  =S  =T  =U  =V  =W  =X  =Y  =Z  =[  =\  =]  =^  =_  =`  =a  =b  =c  =d  =e  =f  =g  =h  =i  =j  =k  =l  =m  =n  =o  =p  =q  =r  =s  =t  =u  =v  =w  =x  =y  =z  ={  =|  =}  =~  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =  =   =    =   =   =   =   =   =   =   =   =	   =
   =   =   =
   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =!   ="   =#   =$   =%   =&   ='   =(   =)   =*   =+   =,   =-   =.   =/   =0   =1   =2   =3   =4   =5   =6   =7   =8   =9   =:   =;   =<   ==   =>   =?   =@   =A   =B   =C   =D   =E   =F   =G   =H   =I   =J   =K   =L   =M   =N   =O   =P   =Q   =R   =S   =T   =U   =V   =W   =X   =Y   =Z   =[   =\   =]   =^   =_   =`   =a   =b   =c   =d   =e   =f   =g   =h   =i   =j   =k   =l   =m   =n   =o   =p   =q   =r   =s   =t   =u   =v   =w   =x   =y   =z   ={   =|   =}   =~   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =   =                               	   
         
                                                         !   "   #   $   %   &   '   (   )   *   +   ,   -   .   /   0   1   2   3   4   5   6   7   8   9   :   ;   <   >   ?   @   A   B   C   D   E   F   G   H   I   J   K   L   M   N   O   P   Q   R   S   T   U   V   W   X   Y   Z   [   \   ]   ^   _   `   a   b   c   d   e   f   g   h   i   j   k   l   m   n   o   p   q   r   s   t   u   v   w   x   y   z   {   |   }   ~                                                                                                                                                                                                                                                                                                                                                                                                                        	  
      
                                      !  "  #  $  %  &  '  (  )  *  +  ,  -  .  /  0  1  2  3  4  5  6  7  8  9  :  ;  <  >  ?  @  A  B  C  D  E  F  G  H  I  J  K  L  M  N  O  P  Q  R  S  T  U  V  W  X  Y  Z  [  \  ]  ^  _  `  a  b  c  d  e  f  g  h  i  j  k  l  m  n  o  p  q  r  s  t  u  v  w  x  y  z  {  |  }  ~                                                                                                                                                                                                                                                                             	 
   
                   ! " # $ % & ' ( ) * + , - . / 0 1 2 3 4 5 6 7 8 9 : ; < > ? @ A B C D E F G H I J K L M N O P Q R S T U V W X Y Z [ \ ] ^ _ ` a b c d e f g h i j k l m n o p q r s t u v w x y z { | } ~                                                                                                                                 = =========	=
===
===================!="=#=$=%=&='=(=)=*=+=,=-=.=/=0=1=2=3=4=5=6=7=8=9=:=;=<===>=?=@=A=B=C=D=E=F=G=H=I=J=K=L=M=N=O=P=Q=R=S=T=U=V=W=X=Y=Z=[=\=]=^=_=`=a=b=c=d=e=f=g=h=i=j=k=l=m=n=o=p=q=r=s=t=u=v=w=x=y=z={=|=}=~=================================================================================================================================                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             	

 "'>	

 "'>	

 "'>	

 "'>	!!
##
$$ %%"&&'((>))	**
++
,, --"..'//>00	11
22
33 44"55'66>77	88
99
:: ;;"<<'==>??	@@
AA
BB CC"DD'EE>FF	GG
HH
II JJ"KK'LL>MM	NN
OO
PP QQ"RR'SS>TT	UU
VV
WW XX"YY'ZZ>[[	\\
]]
^^ __"``'aa>bb	cc
dd
ee ff"gg'hh>ii	jj
kk
ll mm"nn'oo>pp	qq
rr
ss tt"uu'vv>ww	xx
yy
zz {{"||'}}>~~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

  	

 "'>	

 "'>	

 "'>	

 "'>	!
#
$ %"&'(>)	*
+
, -".'/>0	1
2
3 4"5'6>7	8
9
: ;"<'=>?	@
A
B C"D'E>F	G
H
I J"K'L>M	N
O
P Q"R'S>T	U
V
W X"Y'Z>[	\
]
^ _"`'a>b	c
d
e f"g'h>i	j
k
l m"n'o>p	q
r
s t"u'v>w	x
y
z {"|'}>~	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 "'>	

 	

 >"  """"""""""""""""""		""

""""""

""""""""""""""""""""""""""""""""""""""  ""!!""##""$$""%%""&&""''""((""))""**""++"",,""--""..""//""00""11""22""33""44""55""66""77""88""99""::"";;""<<""==""??""@@""AA""BB""CC""DD""EE""FF""GG""HH""II""JJ""KK""LL""MM""NN""OO""PP""QQ""RR""SS""TT""UU""VV""WW""XX""YY""ZZ""[[""\\""]]""^^""__""``""aa""bb""cc""dd""ee""ff""gg""hh""ii""jj""kk""ll""mm""nn""oo""pp""qq""rr""ss""tt""uu""vv""ww""xx""yy""zz""{{""||""}}""~~""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""  >">">">">">">">">"		>"

>">">"

>">">">">">">">">">">">">">">">">">">"  >"!!>"##>"$$>"%%>"&&>"''>"((>"))>"**>"++>",,>"-->"..>"//>"00>"11>"22>"33>"44>"55>"66>"77>"88>"99>"::>";;>"<<>"==>"??>"@@>"AA>"BB>"CC>"DD>"EE>"FF>"GG>"HH>"II>"JJ>"KK>"LL>"MM>"NN>"OO>"PP>"QQ>"RR>"SS>"TT>"UU>"VV>"WW>"XX>"YY>"ZZ>"[[>"\\>"]]>"^^>"__>"``>"aa>"bb>"cc>"dd>"ee>"ff>"gg>"hh>"ii>"jj>"kk>"ll>"mm>"nn>"oo>"pp>"qq>"rr>"ss>"tt>"uu>"vv>"ww>"xx>"yy>"zz>"{{>"||>"}}>"~~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">" """"""""""""""""""	""
""""""
"""""""""""""""""""""""""""""""""""""" ""!""#""$""%""&""'""("")""*""+"",""-"".""/""0""1""2""3""4""5""6""7""8""9"":"";""<""=""?""@""A""B""C""D""E""F""G""H""I""J""K""L""M""N""O""P""Q""R""S""T""U""V""W""X""Y""Z""[""\""]""^""_""`""a""b""c""d""e""f""g""h""i""j""k""l""m""n""o""p""q""r""s""t""u""v""w""x""y""z""{""|""}""~"""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""""" >">">">">">">">">"	>"
>">">"
>">">">">">">">">">">">">">">">">">">" >"!>"#>"$>"%>"&>"'>"(>")>"*>"+>",>"->".>"/>"0>"1>"2>"3>"4>"5>"6>"7>"8>"9>":>";>"<>"=>"?>"@>"A>"B>"C>"D>"E>"F>"G>"H>"I>"J>"K>"L>"M>"N>"O>"P>"Q>"R>"S>"T>"U>"V>"W>"X>"Y>"Z>"[>"\>"]>"^>"_>"`>"a>"b>"c>"d>"e>"f>"g>"h>"i>"j>"k>"l>"m>"n>"o>"p>"q>"r>"s>"t>"u>"v>"w>"x>"y>"z>"{>"|>"}>"~>">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">">""">'  ''''''''''''''''''		''

''''''

''''''''''''''''''''''''''''''''''''''  ''!!''""''##''$$''%%''&&''((''))''**''++'',,''--''..''//''00''11''22''33''44''55''66''77''88''99''::'';;''<<''==''??''@@''AA''BB''CC''DD''EE''FF''GG''HH''II''JJ''KK''LL''MM''NN''OO''PP''QQ''RR''SS''TT''UU''VV''WW''XX''YY''ZZ''[[''\\'']]''^^''__''``''aa''bb''cc''dd''ee''ff''gg''hh''ii''jj''kk''ll''mm''nn''oo''pp''qq''rr''ss''tt''uu''vv''ww''xx''yy''zz''{{''||''}}''~~''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''  >'>'>'>'>'>'>'>'>'		>'

>'>'>'

>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'  >'!!>'"">'##>'$$>'%%>'&&>'((>'))>'**>'++>',,>'-->'..>'//>'00>'11>'22>'33>'44>'55>'66>'77>'88>'99>'::>';;>'<<>'==>'??>'@@>'AA>'BB>'CC>'DD>'EE>'FF>'GG>'HH>'II>'JJ>'KK>'LL>'MM>'NN>'OO>'PP>'QQ>'RR>'SS>'TT>'UU>'VV>'WW>'XX>'YY>'ZZ>'[[>'\\>']]>'^^>'__>'``>'aa>'bb>'cc>'dd>'ee>'ff>'gg>'hh>'ii>'jj>'kk>'ll>'mm>'nn>'oo>'pp>'qq>'rr>'ss>'tt>'uu>'vv>'ww>'xx>'yy>'zz>'{{>'||>'}}>'~~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' ''''''''''''''''''	''
''''''
'''''''''''''''''''''''''''''''''''''' ''!''"''#''$''%''&''('')''*''+'',''-''.''/''0''1''2''3''4''5''6''7''8''9'':'';''<''=''?''@''A''B''C''D''E''F''G''H''I''J''K''L''M''N''O''P''Q''R''S''T''U''V''W''X''Y''Z''[''\'']''^''_''`''a''b''c''d''e''f''g''h''i''j''k''l''m''n''o''p''q''r''s''t''u''v''w''x''y''z''{''|''}''~'''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''''' >'>'>'>'>'>'>'>'>'	>'
>'>'>'
>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>' >'!>'">'#>'$>'%>'&>'(>')>'*>'+>',>'->'.>'/>'0>'1>'2>'3>'4>'5>'6>'7>'8>'9>':>';>'<>'=>'?>'@>'A>'B>'C>'D>'E>'F>'G>'H>'I>'J>'K>'L>'M>'N>'O>'P>'Q>'R>'S>'T>'U>'V>'W>'X>'Y>'Z>'[>'\>']>'^>'_>'`>'a>'b>'c>'d>'e>'f>'g>'h>'i>'j>'k>'l>'m>'n>'o>'p>'q>'r>'s>'t>'u>'v>'w>'x>'y>'z>'{>'|>'}>'~>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'>'''>                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             