// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from RadiusServerSettings.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.radius {

  public class ServerSettings : ICloneable {
    public object Clone() {
      ServerSettings copy = new ServerSettings();
      copy.id = this.id;
      copy.server = this.server;
      copy.sharedSecret = this.sharedSecret;
      copy.udpAuthPort = this.udpAuthPort;
      copy.udpAccountPort = this.udpAccountPort;
      copy.timeout = this.timeout;
      copy.retries = this.retries;
      copy.authType = this.authType;
      return copy;
    }

    public LightJson.JsonObject Encode() {
      LightJson.JsonObject json = new LightJson.JsonObject();
      json["id"] = this.id;
      json["server"] = this.server;
      json["sharedSecret"] = this.sharedSecret;
      json["udpAuthPort"] = this.udpAuthPort;
      json["udpAccountPort"] = this.udpAccountPort;
      json["timeout"] = this.timeout;
      json["retries"] = this.retries;
      json["authType"] = (int)this.authType;
      return json;
    }

    public static ServerSettings Decode(LightJson.JsonObject json, Agent agent) {
      ServerSettings inst = new ServerSettings();
      inst.id = (string)json["id"];
      inst.server = (string)json["server"];
      inst.sharedSecret = (string)json["sharedSecret"];
      inst.udpAuthPort = (int)json["udpAuthPort"];
      inst.udpAccountPort = (int)json["udpAccountPort"];
      inst.timeout = (int)json["timeout"];
      inst.retries = (int)json["retries"];
      inst.authType = (Com.Raritan.Idl.radius.AuthType)(int)json["authType"];
      return inst;
    }

    public string id = "";
    public string server = "";
    public string sharedSecret = "";
    public int udpAuthPort = 0;
    public int udpAccountPort = 0;
    public int timeout = 0;
    public int retries = 0;
    public Com.Raritan.Idl.radius.AuthType authType = Com.Raritan.Idl.radius.AuthType.PAP;
  }
}
