% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layout.R
\name{layout_column_wrap}
\alias{layout_column_wrap}
\title{A grid-like, column-first, layout}
\usage{
layout_column_wrap(
  width,
  ...,
  fixed_width = FALSE,
  heights_equal = c("all", "row"),
  fill = TRUE,
  height = NULL,
  height_mobile = NULL,
  gap = NULL,
  class = NULL
)
}
\arguments{
\item{width}{The desired width of each card, which can be any of the
following:
\itemize{
\item A (unit-less) number between 0 and 1.
\itemize{
\item This should be specified as \code{1/num}, where \code{num} represents the number
of desired columns.
}
\item A \link[htmltools:validateCssUnit]{CSS length unit}
\itemize{
\item Either the minimum (when \code{fixed_width=FALSE}) or fixed width
(\code{fixed_width=TRUE}).
}
\item \code{NULL}
\itemize{
\item Allows power users to set the \code{grid-template-columns} CSS property
manually, either via a \code{style} attribute or a CSS stylesheet.
}
}}

\item{...}{Unnamed arguments should be UI elements (e.g., \code{\link[=card]{card()}})
Named arguments become attributes on the containing \link[htmltools:builder]{htmltools::tag} element.}

\item{fixed_width}{Whether or not to interpret the \code{width} as a minimum
(\code{fixed_width=FALSE}) or fixed (\code{fixed_width=TRUE}) width when it is a CSS
length unit.}

\item{heights_equal}{If \code{"all"} (the default), every card in every row of the
grid will have the same height. If \code{"row"}, then every card in \emph{each} row
of the grid will have the same height, but heights may vary between rows.}

\item{fill}{whether or not the grid items should grow to fill the row height.}

\item{height}{Any valid \link[htmltools:validateCssUnit]{CSS unit} (e.g.,
\code{height="200px"}).}

\item{height_mobile}{Any valid CSS unit to use for the height when on mobile
devices (or narrow windows).}

\item{gap}{A \link[htmltools:validateCssUnit]{CSS length unit} defining the
\code{gap} (i.e., spacing) between elements provided to \code{...}.}

\item{class}{Additional CSS classes for the returned UI element.}
}
\description{
Wraps a 1d sequence of UI elements into a 2d grid. The number of columns (and
rows) in the grid dependent on the column \code{width} as well as the size of the
display. For more explanation and illustrative examples, see \href{https://rstudio.github.io/bslib/articles/cards.html#multiple-cards}{here}
}
\examples{

x <- card("A simple card")
# Always has 2 columns (on non-mobile)
layout_column_wrap(1/2, x, x, x)
# Has three columns when viewport is wider than 750px
layout_column_wrap("250px", x, x, x)

}
