# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.resource.links.v2016_09_01 import ManagementLinkClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestManagementLinkResourceLinksOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(ManagementLinkClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_links_delete(self, resource_group):
        response = self.client.resource_links.delete(
            link_id="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_links_create_or_update(self, resource_group):
        response = self.client.resource_links.create_or_update(
            link_id="str",
            parameters={
                "id": "str",
                "name": "str",
                "properties": {"targetId": "str", "notes": "str", "sourceId": "str"},
                "type": {},
            },
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_links_get(self, resource_group):
        response = self.client.resource_links.get(
            link_id="str",
            api_version="2016-09-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_links_list_at_subscription(self, resource_group):
        response = self.client.resource_links.list_at_subscription(
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_resource_links_list_at_source_scope(self, resource_group):
        response = self.client.resource_links.list_at_source_scope(
            scope="str",
            api_version="2016-09-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...
