//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//
// Copyright (c) Copyright (c) 2015-2019, Lawrence Livermore National Security, LLC.
//
// Produced at the Lawrence Livermore National Laboratory
//
// LLNL-CODE-666778
//
// All rights reserved.
//
// This file is part of Conduit.
//
// For details, see: http://software.llnl.gov/conduit/.
//
// Please also read conduit/LICENSE
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions are met:
//
// * Redistributions of source code must retain the above copyright notice,
//   this list of conditions and the disclaimer below.
//
// * Redistributions in binary form must reproduce the above copyright notice,
//   this list of conditions and the disclaimer (as noted below) in the
//   documentation and/or other materials provided with the distribution.
//
// * Neither the name of the LLNS/LLNL nor the names of its contributors may
//   be used to endorse or promote products derived from this software without
//   specific prior written permission.
//
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
// AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
// IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
// ARE DISCLAIMED. IN NO EVENT SHALL LAWRENCE LIVERMORE NATIONAL SECURITY,
// LLC, THE U.S. DEPARTMENT OF ENERGY OR CONTRIBUTORS BE LIABLE FOR ANY
// DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
// OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
// HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
// STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
// IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
// POSSIBILITY OF SUCH DAMAGE.
//
//~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~//


//-----------------------------------------------------------------------------
///
/// file: conduit_cpp_to_c.hpp
///
//-----------------------------------------------------------------------------

#ifndef CONDUIT_CPP_TO_C_HPP
#define CONDUIT_CPP_TO_C_HPP

#include "conduit.hpp"

#include "conduit.h"

//-----------------------------------------------------------------------------
// -- begin conduit:: --
//-----------------------------------------------------------------------------
namespace conduit
{

//---------------------------------------------------------------------------//
CONDUIT_API conduit::Node *cpp_node(conduit_node *cnode);
//---------------------------------------------------------------------------//
CONDUIT_API conduit_node *c_node(conduit::Node *node);

//---------------------------------------------------------------------------//
CONDUIT_API const conduit::Node *cpp_node(const conduit_node *cnode);
//---------------------------------------------------------------------------//
CONDUIT_API const conduit_node *c_node(const conduit::Node *node);

//---------------------------------------------------------------------------//
CONDUIT_API conduit::Node &cpp_node_ref(conduit_node *cnode);
//---------------------------------------------------------------------------//
CONDUIT_API const conduit::Node &cpp_node_ref(const conduit_node *cnode);


//---------------------------------------------------------------------------//
CONDUIT_API conduit::DataType *cpp_datatype(conduit_datatype *cdatatype);
//---------------------------------------------------------------------------//
CONDUIT_API conduit_datatype  *c_datatype(conduit::DataType  *datatype);

//---------------------------------------------------------------------------//
CONDUIT_API const conduit::DataType *cpp_datatype(const conduit_datatype *cdatatype);
//---------------------------------------------------------------------------//
CONDUIT_API const conduit_datatype  *c_datatype(const conduit::DataType *datatype);

//---------------------------------------------------------------------------//
CONDUIT_API conduit::DataType &cpp_datatype_ref(conduit_datatype *cdatatype);
//---------------------------------------------------------------------------//
CONDUIT_API const conduit::DataType &cpp_datatype_ref(const conduit_datatype *datatype);

}
//-----------------------------------------------------------------------------
// -- end conduit:: --
//-----------------------------------------------------------------------------


#endif
