// Copyright Earl Warren <contact@earl-warren.org>
// Copyright Loïc Dachary <loic@dachary.org>
// SPDX-License-Identifier: MIT

package forge

import (
	"testing"

	"code.forgejo.org/f3/gof3/v3/kind"
	"code.forgejo.org/f3/gof3/v3/options"
)

type Interface interface {
	GetName() string
	SetName(string)

	DeleteAfterCompliance() bool

	GetKindExceptions() []kind.Kind
	GetNameExceptions() []string

	GetNonTestUsers() []string

	NewOptions(t *testing.T) options.Interface
}
