/******************************************************************************
 *
 * Project:  GDAL
 * Purpose:  Fuzzer
 * Author:   Even Rouault, even.rouault at spatialys.com
 *
 ******************************************************************************
 * Copyright (c) 2017, Even Rouault <even.rouault at spatialys.com>
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included
 * in all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
 * OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
 * THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
 * FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 ****************************************************************************/

#include <stddef.h>
#include <stdint.h>

#include "ogr_srs_api.h"
#include "cpl_conv.h"
#include "cpl_error.h"

extern "C" int LLVMFuzzerInitialize(int *argc, char ***argv);

int LLVMFuzzerInitialize(int * /*argc*/, char *** /*argv*/)
{
    CPLSetConfigOption("GDAL_HTTP_TIMEOUT", "1");
    CPLSetConfigOption("GDAL_HTTP_CONNECTTIMEOUT", "1");
    return 0;
}

extern "C" int LLVMFuzzerTestOneInput(const uint8_t *buf, size_t len);

int LLVMFuzzerTestOneInput(const uint8_t *buf, size_t len)
{
    OGRSpatialReferenceH hSRS = OSRNewSpatialReference(nullptr);

    char *pszStr = static_cast<char *>(CPLMalloc(len + 1));
    memcpy(pszStr, buf, len);
    pszStr[len] = '\0';

    CPLPushErrorHandler(CPLQuietErrorHandler);
    OGRErr eErr = OSRSetFromUserInput(hSRS, pszStr);

    CPLFree(pszStr);

    if (eErr == OGRERR_NONE)
    {
        OGRSpatialReferenceH hSRSClone = OSRClone(hSRS);
        OSRMorphFromESRI(hSRSClone);
        OSRDestroySpatialReference(hSRSClone);
    }

    if (eErr == OGRERR_NONE)
    {
        OGRSpatialReferenceH hSRSClone = OSRClone(hSRS);
        OSRMorphToESRI(hSRSClone);
        OSRDestroySpatialReference(hSRSClone);
    }
    CPLPopErrorHandler();

    OSRDestroySpatialReference(hSRS);

    return 0;
}
