/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.imap.protocol;

import com.sun.mail.iap.ParsingException;
import com.sun.mail.iap.Response;
import com.sun.mail.imap.protocol.FetchResponse;
import com.sun.mail.imap.protocol.IMAPAddress;
import com.sun.mail.imap.protocol.Item;
import java.util.Date;
import java.util.Vector;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MailDateFormat;

public class ENVELOPE
implements Item {
    public static char[] name = new char[]{'E', 'N', 'V', 'E', 'L', 'O', 'P', 'E'};
    public int msgno;
    public Date date;
    public String subject;
    public InternetAddress[] from;
    public InternetAddress[] sender;
    public InternetAddress[] replyTo;
    public InternetAddress[] to;
    public InternetAddress[] cc;
    public InternetAddress[] bcc;
    public String inReplyTo;
    public String messageId;
    private static MailDateFormat mailDateFormat = new MailDateFormat();

    public ENVELOPE(FetchResponse fetchResponse) throws ParsingException {
        this.msgno = fetchResponse.getNumber();
        fetchResponse.skipSpaces();
        if (fetchResponse.readByte() != 40) {
            throw new ParsingException("ENVELOPE parse error");
        }
        String string = fetchResponse.readString();
        if (string != null) {
            try {
                this.date = mailDateFormat.parse(string);
            }
            catch (Exception exception) {}
        }
        this.subject = fetchResponse.readString();
        this.from = this.parseAddressList(fetchResponse);
        this.sender = this.parseAddressList(fetchResponse);
        this.replyTo = this.parseAddressList(fetchResponse);
        this.to = this.parseAddressList(fetchResponse);
        this.cc = this.parseAddressList(fetchResponse);
        this.bcc = this.parseAddressList(fetchResponse);
        this.inReplyTo = fetchResponse.readString();
        this.messageId = fetchResponse.readString();
        if (fetchResponse.readByte() != 41) {
            throw new ParsingException("ENVELOPE parse error");
        }
    }

    private InternetAddress[] parseAddressList(Response response) throws ParsingException {
        response.skipSpaces();
        byte by = response.readByte();
        if (by == 40) {
            Vector<IMAPAddress> vector = new Vector<IMAPAddress>();
            do {
                vector.addElement(new IMAPAddress(response));
            } while (response.peekByte() != 41);
            response.skip(1);
            Object[] objectArray = new InternetAddress[vector.size()];
            vector.copyInto(objectArray);
            return objectArray;
        }
        if (by == 78 || by == 110) {
            response.skip(2);
            return null;
        }
        throw new ParsingException("ADDRESS parse error");
    }
}

