{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetDistanceFromShape: Single;
    procedure SetDistanceFromShape(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdDistanceFromShape: TSFFloat;
    { Internal wrapper for property @link(DistanceFromShape). This wrapper API may change, we advise to access simpler @link(DistanceFromShape) instead. }
    public property FdDistanceFromShape: TSFFloat read FFdDistanceFromShape;
    {  }
    property DistanceFromShape: Single read GetDistanceFromShape write SetDistanceFromShape;

{$endif read_interface}

{$ifdef read_implementation}

{ TViewpointMirrorNode ----------------------------------------------- }

function TViewpointMirrorNode.GetDistanceFromShape: Single;
begin
  Result := FdDistanceFromShape.Value;
end;

procedure TViewpointMirrorNode.SetDistanceFromShape(const Value: Single);
begin
  FdDistanceFromShape.Send(Value);
end;

class function TViewpointMirrorNode.ClassX3DType: String;
begin
  Result := 'ViewpointMirror';
end;

procedure TViewpointMirrorNode.CreateNode;
begin
  inherited;

  FFdDistanceFromShape := TSFFloat.Create(Self, True, 'distanceFromShape', 0.01);
   FdDistanceFromShape.ChangeAlways := chVisibleNonGeometry;
  AddField(FFdDistanceFromShape);

  DefaultContainerField := 'viewpoint';
end;

{$endif read_implementation}
