{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetFieldOfView: Single;
    procedure SetFieldOfView(const Value: Single);
    function GetFieldOfViewForceVertical: Boolean;
    procedure SetFieldOfViewForceVertical(const Value: Boolean);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;

    strict private FFdFieldOfView: TSFFloat;
    { Internal wrapper for property @link(FieldOfView). This wrapper API may change, we advise to access simpler @link(FieldOfView) instead. }
    public property FdFieldOfView: TSFFloat read FFdFieldOfView;
    {  }
    property FieldOfView: Single read GetFieldOfView write SetFieldOfView;

    strict private FFdPosition: TSFVec3f;
    { Internal wrapper for property @link(Position). This wrapper API may change, we advise to access simpler @link(Position) instead. }
    public property FdPosition: TSFVec3f read FFdPosition;

    strict private FFdFieldOfViewForceVertical: TSFBool;
    { Internal wrapper for property @link(FieldOfViewForceVertical). This wrapper API may change, we advise to access simpler @link(FieldOfViewForceVertical) instead. }
    public property FdFieldOfViewForceVertical: TSFBool read FFdFieldOfViewForceVertical;
    {  }
    property FieldOfViewForceVertical: Boolean read GetFieldOfViewForceVertical write SetFieldOfViewForceVertical;

{$endif read_interface}

{$ifdef read_implementation}

{ TViewpointNode ----------------------------------------------- }

function TViewpointNode.GetFieldOfView: Single;
begin
  Result := FdFieldOfView.Value;
end;

procedure TViewpointNode.SetFieldOfView(const Value: Single);
begin
  FdFieldOfView.Send(Value);
end;

function TViewpointNode.GetFieldOfViewForceVertical: Boolean;
begin
  Result := FdFieldOfViewForceVertical.Value;
end;

procedure TViewpointNode.SetFieldOfViewForceVertical(const Value: Boolean);
begin
  FdFieldOfViewForceVertical.Send(Value);
end;

class function TViewpointNode.ClassX3DType: String;
begin
  Result := 'Viewpoint';
end;

procedure TViewpointNode.CreateNode;
begin
  inherited;

  FFdFieldOfView := TSFFloat.Create(Self, True, 'fieldOfView', Pi/4);
   FdFieldOfView.ChangeAlways := chViewpointProjection;
  AddField(FFdFieldOfView);

  FFdPosition := TSFVec3f.Create(Self, True, 'position', Vector3(0, 0, 10));
   FdPosition.ChangeAlways := chViewpointVectors;
  AddField(FFdPosition);

  FFdFieldOfViewForceVertical := TSFBool.Create(Self, True, 'fieldOfViewForceVertical', false);
   FdFieldOfViewForceVertical.ChangeAlways := chViewpointProjection;
  AddField(FFdFieldOfViewForceVertical);
end;

{$endif read_implementation}
