{ -*- buffer-read-only: t -*-

  Copyright 2015-2022 Michalis Kamburelis.

  This file is part of "Castle Game Engine".

  "Castle Game Engine" is free software; see the file COPYING.txt,
  included in this distribution, for details about the copyright.

  "Castle Game Engine" is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

  ----------------------------------------------------------------------------
}

{ Automatically generated node properties.

  Do not edit this file manually!
  To add new properties:
  - add them to the text files in tools/internal/x3d-nodes-to-pascal/nodes-specification/ ,
  - and regenerate include files by running x3d-nodes-to-pascal }

{$ifdef read_interface}

  strict private
    function GetSpacing: Single;
    procedure SetSpacing(const Value: Single);
  public
    procedure CreateNode; override;
    class function ClassX3DType: string; override;
    class function ForVRMLVersion(const Version: TX3DVersion): Boolean; override;

    strict private FFdString: TMFString;
    { Internal wrapper for property @link(Text). This wrapper API may change, we advise to access simpler @link(Text) instead. }
    public property FdString: TMFString read FFdString;
    {  }
    procedure SetText(const Value: array of string); overload;
    {  }
    procedure SetText(const Value: TCastleStringList); overload;

    strict private FFdSpacing: TSFFloat;
    { Internal wrapper for property @link(Spacing). This wrapper API may change, we advise to access simpler @link(Spacing) instead. }
    public property FdSpacing: TSFFloat read FFdSpacing;
    {  }
    property Spacing: Single read GetSpacing write SetSpacing;

    strict private FFdJustification: TSFEnum;
    { Internal wrapper for property @link(Justification). This wrapper API may change, we advise to access simpler @link(Justification) instead. }
    public property FdJustification: TSFEnum read FFdJustification;

    strict private FFdWidth: TMFFloat;
    { Internal wrapper for property @link(Width). This wrapper API may change, we advise to access simpler @link(Width) instead. }
    public property FdWidth: TMFFloat read FFdWidth;
    {  }
    procedure SetWidth(const Value: array of Single); overload;
    {  }
    procedure SetWidth(const Value: TSingleList); overload;

{$endif read_interface}

{$ifdef read_implementation}

{ TAsciiTextNode_1 ----------------------------------------------- }

procedure TAsciiTextNode_1.SetText(const Value: array of string);
begin
  FdString.Send(Value);
end;

procedure TAsciiTextNode_1.SetText(const Value: TCastleStringList);
begin
  FdString.Send(Value);
end;

function TAsciiTextNode_1.GetSpacing: Single;
begin
  Result := FdSpacing.Value;
end;

procedure TAsciiTextNode_1.SetSpacing(const Value: Single);
begin
  FdSpacing.Send(Value);
end;

procedure TAsciiTextNode_1.SetWidth(const Value: array of Single);
begin
  FdWidth.Send(Value);
end;

procedure TAsciiTextNode_1.SetWidth(const Value: TSingleList);
begin
  FdWidth.Send(Value);
end;

class function TAsciiTextNode_1.ForVRMLVersion(const Version: TX3DVersion): Boolean;
begin
  Result := Version.Major <= 1; // parse this node only in VRML 1.0 and Inventor files
end;

class function TAsciiTextNode_1.ClassX3DType: String;
begin
  Result := 'AsciiText';
end;

procedure TAsciiTextNode_1.CreateNode;
begin
  inherited;

  FFdString := TMFString.Create(Self, True, 'string', ['']);
   FdString.ChangeAlways := chGeometry;
  AddField(FFdString);

  FFdSpacing := TSFFloat.Create(Self, True, 'spacing', 1);
   FdSpacing.ChangeAlways := chGeometry;
  AddField(FFdSpacing);

  FFdJustification := TSFEnum.Create(Self, True, 'justification', @JustificationNames1, Ord(High(JustificationNames1)) + 1, JUSTIFICATION_LEFT);
   FdJustification.ChangeAlways := chGeometry;
  AddField(FFdJustification);

  FFdWidth := TMFFloat.Create(Self, True, 'width', [0]);
   FdWidth.ChangeAlways := chGeometry;
  AddField(FFdWidth);
end;

{$endif read_implementation}
