/*
 * Copyright (c) 2019-2023, Intel Corporation. All rights reserved.
 *
 * SPDX-License-Identifier: BSD-3-Clause
 */

#ifndef SOCFPGA_RESETMANAGER_H
#define SOCFPGA_RESETMANAGER_H

#include "socfpga_plat_def.h"

/* Status Response */
#define RSTMGR_RET_OK				0
#define RSTMGR_RET_ERROR			-1

#define SOCFPGA_BRIDGE_ENABLE			BIT(0)
#define SOCFPGA_BRIDGE_HAS_MASK			BIT(1)

#define SOC2FPGA_MASK				(1<<0)
#define LWHPS2FPGA_MASK				(1<<1)
#define FPGA2SOC_MASK				(1<<2)
#define F2SDRAM0_MASK				(1<<3)
#define F2SDRAM1_MASK				(1<<4)
#define F2SDRAM2_MASK				(1<<5)

/* Register Mapping */

#define SOCFPGA_RSTMGR_STAT			0x000
#define SOCFPGA_RSTMGR_MISCSTAT			0x008
#define SOCFPGA_RSTMGR_HDSKEN			0x010
#define SOCFPGA_RSTMGR_HDSKREQ			0x014
#define SOCFPGA_RSTMGR_HDSKACK			0x018
#define SOCFPGA_RSTMGR_HDSKSTALL		0x01C
#if PLATFORM_MODEL != PLAT_SOCFPGA_AGILEX5
#define SOCFPGA_RSTMGR_MPUMODRST		0x020
#endif
#define SOCFPGA_RSTMGR_PER0MODRST		0x024
#define SOCFPGA_RSTMGR_PER1MODRST		0x028
#define SOCFPGA_RSTMGR_BRGMODRST		0x02C
#if PLATFORM_MODEL != PLAT_SOCFPGA_AGILEX5
#define SOCFPGA_RSTMGR_COLDMODRST		0x034
#endif
#define SOCFPGA_RSTMGR_DBGMODRST		0x03C
#define SOCFPGA_RSTMGR_BRGWARMMASK		0x04C
#define SOCFPGA_RSTMGR_TSTSTA			0x05C
#define SOCFPGA_RSTMGR_HDSKTIMEOUT		0x064
#define SOCFPGA_RSTMGR_DBGHDSKTIMEOUT		0x06C
#define SOCFPGA_RSTMGR_DBGRSTCMPLT		0x070
#define SOCFPGA_RSTMGR_HPSRSTCMPLT		0x080
#define SOCFPGA_RSTMGR_CPUINREST		0x090
#define SOCFPGA_RSTMGR_CPURSTRELEASE		0x094
#define SOCFPGA_RSTMGR_CPUBASELOW_0		0x098
#define SOCFPGA_RSTMGR_CPUBASEHIGH_0		0x09C
#define SOCFPGA_RSTMGR_CPUBASELOW_1		0x0A0
#define SOCFPGA_RSTMGR_CPUBASEHIGH_1		0x0A4
#define SOCFPGA_RSTMGR_CPUBASELOW_2		0x0A8
#define SOCFPGA_RSTMGR_CPUBASEHIGH_2		0x0AC
#define SOCFPGA_RSTMGR_CPUBASELOW_3		0x0B0
#define SOCFPGA_RSTMGR_CPUBASEHIGH_3		0x0B4

/* Field Mapping */
/* PER0MODRST */
#define RSTMGR_PER0MODRST_EMAC0			0x00000001	//TSN0
#define RSTMGR_PER0MODRST_EMAC1			0x00000002	//TSN1
#define RSTMGR_PER0MODRST_EMAC2			0x00000004	//TSN2
#define RSTMGR_PER0MODRST_USB0			0x00000008
#define RSTMGR_PER0MODRST_USB1			0x00000010
#define RSTMGR_PER0MODRST_NAND			0x00000020
#define RSTMGR_PER0MODRST_SOFTPHY		0x00000040
#define RSTMGR_PER0MODRST_SDMMC			0x00000080
#define RSTMGR_PER0MODRST_EMAC0OCP		0x00000100	//TSN0ECC
#define RSTMGR_PER0MODRST_EMAC1OCP		0x00000200	//TSN1ECC
#define RSTMGR_PER0MODRST_EMAC2OCP		0x00000400	//TSN2ECC
#define RSTMGR_PER0MODRST_USB0OCP		0x00000800
#define RSTMGR_PER0MODRST_USB1OCP		0x00001000
#define RSTMGR_PER0MODRST_NANDOCP		0x00002000
#define RSTMGR_PER0MODRST_SDMMCOCP		0x00008000
#define RSTMGR_PER0MODRST_DMA			0x00010000
#define RSTMGR_PER0MODRST_SPIM0			0x00020000
#define RSTMGR_PER0MODRST_SPIM1			0x00040000
#define RSTMGR_PER0MODRST_SPIS0			0x00080000
#define RSTMGR_PER0MODRST_SPIS1			0x00100000
#define RSTMGR_PER0MODRST_DMAOCP		0x00200000
#define RSTMGR_PER0MODRST_EMACPTP		0x00400000
#define RSTMGR_PER0MODRST_DMAIF0		0x01000000
#define RSTMGR_PER0MODRST_DMAIF1		0x02000000
#define RSTMGR_PER0MODRST_DMAIF2		0x04000000
#define RSTMGR_PER0MODRST_DMAIF3		0x08000000
#define RSTMGR_PER0MODRST_DMAIF4		0x10000000
#define RSTMGR_PER0MODRST_DMAIF5		0x20000000
#define RSTMGR_PER0MODRST_DMAIF6		0x40000000
#define RSTMGR_PER0MODRST_DMAIF7		0x80000000

/* PER1MODRST */
#define RSTMGR_PER1MODRST_WATCHDOG0		0x00000001
#define RSTMGR_PER1MODRST_WATCHDOG1		0x00000002
#define RSTMGR_PER1MODRST_WATCHDOG2		0x00000004
#define RSTMGR_PER1MODRST_WATCHDOG3		0x00000008
#define RSTMGR_PER1MODRST_L4SYSTIMER0		0x00000010
#define RSTMGR_PER1MODRST_L4SYSTIMER1		0x00000020
#define RSTMGR_PER1MODRST_SPTIMER0		0x00000040
#define RSTMGR_PER1MODRST_SPTIMER1		0x00000080
#define RSTMGR_PER1MODRST_I2C0			0x00000100
#define RSTMGR_PER1MODRST_I2C1			0x00000200
#define RSTMGR_PER1MODRST_I2C2			0x00000400
#define RSTMGR_PER1MODRST_I2C3			0x00000800
#define RSTMGR_PER1MODRST_I2C4			0x00001000
#define RSTMGR_PER1MODRST_I3C0			0x00002000
#define RSTMGR_PER1MODRST_I3C1			0x00004000
#define RSTMGR_PER1MODRST_UART0			0x00010000
#define RSTMGR_PER1MODRST_UART1			0x00020000
#define RSTMGR_PER1MODRST_GPIO0			0x01000000
#define RSTMGR_PER1MODRST_GPIO1			0x02000000
#define RSTMGR_PER1MODRST_WATCHDOG4		0x04000000

/* HDSKEN */
#define RSTMGR_HDSKEN_EMIF_FLUSH		0x00000001
#define RSTMGR_HDSKEN_FPGAHSEN			0x00000004
#define RSTMGR_HDSKEN_ETRSTALLEN		0x00000008
#define RSTMGR_HDSKEN_LWS2F_FLUSH		0x00000200
#define RSTMGR_HDSKEN_S2F_FLUSH			0x00000400
#define RSTMGR_HDSKEN_F2SDRAM_FLUSH		0x00000800
#define RSTMGR_HDSKEN_F2S_FLUSH			0x00001000
#define RSTMGR_HDSKEN_L3NOC_DBG			0x00010000
#define RSTMGR_HDSKEN_DEBUG_L3NOC		0x00020000

/* HDSKREQ */
#define RSTMGR_HDSKREQ_EMIFFLUSHREQ		0x00000001
#define RSTMGR_HDSKREQ_ETRSTALLREQ		0x00000008
#define RSTMGR_HDSKREQ_LWS2F_FLUSH		0x00000200
#define RSTMGR_HDSKREQ_S2F_FLUSH		0x00000400
#define RSTMGR_HDSKREQ_F2SDRAM_FLUSH		0x00000800
#define RSTMGR_HDSKREQ_F2S_FLUSH		0x00001000
#define RSTMGR_HDSKREQ_L3NOC_DBG		0x00010000
#define RSTMGR_HDSKREQ_DEBUG_L3NOC		0x00020000
#define RSTMGR_HDSKREQ_FPGAHSREQ		0x00000004
#define RSTMGR_HDSKREQ_LWSOC2FPGAREQ		0x00000200
#define RSTMGR_HDSKREQ_SOC2FPGAREQ		0x00000400
#define RSTMGR_HDSKREQ_F2SDRAM0REQ		0x00000800
#define RSTMGR_HDSKREQ_FPGA2SOCREQ		0x00001000

/* HDSKACK */
#define RSTMGR_HDSKACK_EMIFFLUSHREQ		0x00000001
#define RSTMGR_HDSKACK_FPGAHSREQ		0x00000004
#define RSTMGR_HDSKACK_ETRSTALLREQ		0x00000008
#define RSTMGR_HDSKACK_LWS2F_FLUSH		0x00000200
#define RSTMGR_HDSKACK_S2F_FLUSH		0x00000400
#define RSTMGR_HDSKACK_F2SDRAM_FLUSH		0x00000800
#define RSTMGR_HDSKACK_F2S_FLUSH		0x00001000
#define RSTMGR_HDSKACK_L3NOC_DBG		0x00010000
#define RSTMGR_HDSKACK_DEBUG_L3NOC		0x00020000
#define RSTMGR_HDSKACK_FPGAHSACK		0x00000004
#define RSTMGR_HDSKACK_LWSOC2FPGAACK		0x00000200
#define RSTMGR_HDSKACK_SOC2FPGAACK		0x00000400
#define RSTMGR_HDSKACK_F2SDRAM0ACK		0x00000800
#define RSTMGR_HDSKACK_FPGA2SOCACK		0x00001000
#define RSTMGR_HDSKACK_FPGAHSACK_DASRT		0x00000000
#define RSTMGR_HDSKACK_LWSOC2FPGAACK_DASRT	0x00000000
#define RSTMGR_HDSKACK_SOC2FPGAACK_DASRT	0x00000000
#define RSTMGR_HDSKACK_F2SDRAM0ACK_DASRT	0x00000000
#define RSTMGR_HDSKACK_FPGA2SOCACK_DASRT	0x00000000

/* HDSKSTALL */
#define RSTMGR_HDSKACK_ETRSTALLWARMRST		0x00000001

/* BRGMODRST */
#define RSTMGR_BRGMODRST_SOC2FPGA		0x00000001
#define RSTMGR_BRGMODRST_LWHPS2FPGA		0x00000002
#define RSTMGR_BRGMODRST_FPGA2SOC		0x00000004
#define RSTMGR_BRGMODRST_F2SSDRAM0		0x00000008
#if PLATFORM_MODEL == PLAT_SOCFPGA_STRATIX10
#define RSTMGR_BRGMODRST_F2SSDRAM1		0x10
#define RSTMGR_BRGMODRST_F2SSDRAM2		0x20
#define RSTMGR_BRGMODRST_DDRSCH			0x40
#elif PLATFORM_MODEL == PLAT_SOCFPGA_AGILEX5
#define RSTMGR_BRGMODRST_F2SSDRAM1		0x10
#define RSTMGR_BRGMODRST_F2SSDRAM2		0x20
#endif

#define RSTMGR_BRGMODRST_MPFE			0x40

/* DBGMODRST */
#define RSTMGR_DBGMODRST_DBG_RST		0x00000001

/* BRGMODRSTMASK */
#define RSTMGR_BRGMODRSTMASK_SOC2FPGA		0x00000001
#define RSTMGR_BRGMODRSTMASK_LWHPS2FPGA		0x00000002
#define RSTMGR_BRGMODRSTMASK_FPGA2SOC		0x00000004
#define RSTMGR_BRGMODRSTMASK_F2SDRAM0		0x00000008
#define RSTMGR_BRGMODRSTMASK_MPFE		0x00000040

/* TSTSTA */
#define RSTMGR_TSTSTA_RSTST			0x0000001F

/* HDSKTIMEOUT */
#define RSTMGR_HDSKTIMEOUT_VAL			0xFFFFFFFF

/* DBGHDSKTIMEOUT */
#define RSTMGR_DBGHDSKTIMEOUT_VAL		0xFFFFFFFF

/* DBGRSTCMPLT */
#define RSTMGR_DBGRSTCMPLT_VAL			0xFFFFFFFF

/* HPSRSTCMPLT */
#define RSTMGR_DBGRSTCMPLT_VAL			0xFFFFFFFF

/* CPUINRESET */
#define RSTMGR_CPUINRESET_CPU0			0x00000001
#define RSTMGR_CPUINRESET_CPU1			0x00000002
#define RSTMGR_CPUINRESET_CPU2			0x00000004
#define RSTMGR_CPUINRESET_CPU3			0x00000008

/* CPUSTRELEASE */
#define RSTMGR_CPUSTRELEASE_CPUx		0x10D11094

/* CPUxRESETBASE */
#define RSTMGR_CPUxRESETBASELOW_CPU0		0x10D11098
#define RSTMGR_CPUxRESETBASEHIGH_CPU0		0x10D1109C
#define RSTMGR_CPUxRESETBASELOW_CPU1		0x10D110A0
#define RSTMGR_CPUxRESETBASEHIGH_CPU1		0x10D110A4
#define RSTMGR_CPUxRESETBASELOW_CPU2		0x10D110A8
#define RSTMGR_CPUxRESETBASEHIGH_CPU2		0x10D110AC
#define RSTMGR_CPUxRESETBASELOW_CPU3		0x10D110B0
#define RSTMGR_CPUxRESETBASEHIGH_CPU3		0x10D110B4

/* Definitions */

#define RSTMGR_L2_MODRST			0x0100
#define RSTMGR_HDSKEN_SET			0x010D

/* Macros */
#define SOCFPGA_RSTMGR(_reg)			(SOCFPGA_RSTMGR_REG_BASE + (SOCFPGA_RSTMGR_##_reg))
#define RSTMGR_FIELD(_reg, _field)		(RSTMGR_##_reg##MODRST_##_field)

/* Reset type to SDM from PSCI */
// Temp add macro here for reset type
#define SOCFPGA_RESET_TYPE_COLD			0
#define SOCFPGA_RESET_TYPE_WARM			1

/* Function Declarations */

void deassert_peripheral_reset(void);
void config_hps_hs_before_warm_reset(void);

int socfpga_bridges_reset(uint32_t mask);
int socfpga_bridges_enable(uint32_t mask);
int socfpga_bridges_disable(uint32_t mask);

int socfpga_cpurstrelease(unsigned int cpu_id);
int socfpga_cpu_reset_base(unsigned int cpu_id);

/* SMP: Func proto */
void bl31_plat_set_secondary_cpu_entrypoint(unsigned int cpu_id);
void bl31_plat_set_secondary_cpu_off(void);

#endif /* SOCFPGA_RESETMANAGER_H */
